﻿var attributeSelector = {
    surveyId: 0,
    datatable: null,
    showFilters: false,
    limitRowCount: 10,
    initializeDataTable: function () {
        var includeSystemAttributes = $(".v-includeSystemAttributes").val() ? true : false;
        var enableLimitedSelection = $(".v-enableLimitedSelection").val() ? true : false;
        var selectedAttributes = $(".v-selectedAttributes").val();
        if (!selectedAttributes || selectedAttributes.length == 0) {
            var panelAttributeEditor = a4.parent($(".v-selectedAttributes")).panelAttributeEditor;

            if (panelAttributeEditor && panelAttributeEditor.currentData != null && panelAttributeEditor.currentData != "") {
                selectedAttributes = panelAttributeEditor.currentData;
            }
        }

        this.datatable = $(".h-attributes-table").a4datatable({
            ajaxAction: a4.getAction("GetPanelistAttributesForSelection", "Panelists", "Panel"),
            ajaxParams: { "includeSystemAttributes": includeSystemAttributes },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Key": true},
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "Type", "Title": resources.Type, "Data": "Type", "Sortable": false }
            ],
            allowRowSelection: function (data) { return true; },
            rememberRowSelection: true,
            limitRowSelection: enableLimitedSelection ? attributeSelector.limitRowCount : null,
            selectedRows: (!selectedAttributes || selectedAttributes.length == 0) ? '' : _.pluck(JSON.parse(selectedAttributes), "Id").join(','),
            style: "compact" 
        });

        if (!attributeSelector.showFilters) {
            var $selectionPanel = $(".v-selectionPanel");
            $(".h-attributes-table .top").prepend($selectionPanel.css("float", "left"));
        }
    },
    bindEvents: function () {
        $(document).on("click", ".v-confirmButton", function () {
            var selectedAttributes = attributeSelector.datatable.a4datatable("getSelectedItems");
            var selectedAttributeIds = selectedAttributes.map(function (a) { return { 'Id': a.Id } })
            $(".v-selectedAttributes").val(JSON.stringify(selectedAttributeIds));
            $(".v-confirmed").val("true");
            modalDialog.close();
        });

        $(document).on("click", ".h-selectAllRows", function () {
            a4.callServerMethod(a4.getAction("GetPanelAttributeNames", "Panelists", "Panel"), { },
                function (result) {
                    attributeSelector.datatable.a4datatable("option", "selectedRows", result.join());
                });
        });

        $(document).on("click", ".h-unselectAllRows", function () {
            attributeSelector.datatable.a4datatable("option", "selectedRows", "");
        });
    }
}

$(document).ready(function () {
    var limit = parseInt($("#limitCount").val(), 10);
    attributeSelector.surveyId = $("#PanelId").val();
    attributeSelector.limitRowCount = (limit > 0) ? limit : null;
    attributeSelector.showFilters = ($("#showFilters").val() == 'true');
    attributeSelector.initializeDataTable();

    $(".v-selectionPanel").toggle(attributeSelector.limitRowCount == null);
    attributeSelector.bindEvents();
});